# 機能設計書 96-デバッグ操作（Debug Operations）

## 概要

本ドキュメントは、TensorFlowにおけるデバッグ操作（Debug Operations）機能の設計を記述する。テンソル値の監視・デバッグイベント出力・数値チェックを提供する。

### 本機能の処理概要

**業務上の目的・背景**：機械学習モデルの開発・デバッグにおいて、計算グラフ内のテンソル値を観測し、NaN/Inf等の数値異常を検出することは重要である。本機能は、TensorFlow Debugger（tfdbg）のコアとなるOp群であり、グラフ実行中にテンソル値を非破壊的にキャプチャ・分析する仕組みを提供する。

**機能の利用シーン**：モデル学習中の勾配爆発やNaN検出、テンソル値のリアルタイム監視、デバッグダンプの取得、数値サマリーの収集などに使用される。RunOptions.debug_optionsを通じて間接的に使用される。

**主要な処理内容**：
1. `Copy` / `CopyHost` - テンソルの非破壊的コピー（デバッグ用の監視ポイント挿入）
2. `DebugIdentity` / `DebugIdentityV2` / `DebugIdentityV3` - テンソルのID変換（デバッグイベント出力付き）
3. `DebugNanCount` - テンソル内のNaN要素数をカウント
4. `DebugNumericSummary` / `DebugNumericSummaryV2` - テンソルの数値統計サマリー

**関連システム・外部連携**：tfdbg CLIツール、gRPCベースのデバッグサーバー、TensorBoardデバッガーと連携する。

**権限による制御**：特になし。ただし、gated_grpc属性でgRPCゲーティングを制御可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

デバッグ支援（テンソル値監視・数値検証）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | T (任意型) | Yes | 監視対象テンソル | - |
| device_name | string | No | デバイス名（デフォルト: ""） | - |
| tensor_name | string | No | テンソル名（デフォルト: ""） | - |
| debug_urls | list(string) | No | デバッグ出力先URL | - |
| gated_grpc | bool | No | gRPCゲーティング有効化（デフォルト: false） | - |
| tfdbg_context_id | string | No（V2） | デバッグコンテキストID | - |
| tensor_debug_mode | int | No（V2） | テンソルデバッグモード | - |
| circular_buffer_size | int | No（V2） | 循環バッファサイズ（デフォルト: 1000） | - |
| lower_bound | float | No（NumericSummary） | 下限値（デフォルト: -inf） | - |
| upper_bound | float | No（NumericSummary） | 上限値（デフォルト: inf） | - |
| mute_if_healthy | bool | No（NumericSummary） | 正常時のミュート（デフォルト: false） | - |

### 入力データソース

計算グラフ内の任意テンソル。RunOptions経由でデバッグOpが自動挿入される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output (Copy/Identity) | T | 入力と同一のテンソル（形状不変） |
| output (NanCount) | int64 | NaN要素の個数（スカラー） |
| output (NumericSummary) | double | 数値統計サマリー |
| output (NumericSummaryV2) | float32/float64 | 数値統計サマリー（V2） |

### 出力先

デバッグURL（ファイル、gRPC）、tfdbg CLI、TensorBoard。

## 処理フロー

### 処理シーケンス

```
1. デバッグOp挿入
   └─ RunOptions.debug_optionsに基づきグラフにCopy/DebugIdentity Opを挿入
2. テンソル値のキャプチャ
   └─ 入力テンソルを非破壊的にコピー
3. デバッグ分析の実行
   └─ NanCount: NaN要素のカウント
   └─ NumericSummary: 統計情報の計算
4. デバッグイベントの出力
   └─ debug_urlsで指定された宛先にイベントを送信
5. テンソルの転送
   └─ 元のテンソルをそのまま後続Opに渡す
```

### フローチャート

```mermaid
flowchart TD
    A[計算グラフ実行] --> B{debug_options設定あり?}
    B -->|Yes| C[デバッグOp挿入]
    B -->|No| D[通常実行]
    C --> E[テンソルキャプチャ]
    E --> F{Op種別}
    F -->|Copy/Identity| G[テンソルコピー + イベント出力]
    F -->|NanCount| H[NaN数カウント]
    F -->|NumericSummary| I[数値統計計算]
    G --> J[元テンソルを後続に転送]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | 非破壊性 | デバッグOpは入力テンソルを変更しない（Copy/Identity系は入力と同一の出力を返す） | 全Op |
| BR-96-02 | ステートフル | DebugIdentityV2/V3はIsStatefulであり、副作用を持つ | V2/V3 |
| BR-96-03 | 循環バッファ | V2では循環バッファ（デフォルト1000）でデバッグイベントを管理 | V2 |
| BR-96-04 | gRPCゲーティング | gated_grpc=trueの場合、gRPCリクエストを受信した時のみデバッグ出力 | gated_grpc有効時 |

### 計算ロジック

- NanCount: テンソル内の`isnan(x)`がtrueの要素数をカウント
- NumericSummary: min, max, mean, variance, nan_count, inf_count, zero_count等の統計情報を計算

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。デバッグダンプはファイルシステムまたはgRPCに出力。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | gRPC接続エラー | debug_urlsで指定したgRPCサーバーに接続できない | サーバーの起動確認 |
| - | ファイル書き込みエラー | デバッグダンプ先ディレクトリに書き込み権限がない | 権限確認 |

### リトライ仕様

gRPC接続はデバッグフレームワーク側でリトライ管理。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- デバッグOpの挿入は実行時オーバーヘッドを発生させる
- mute_if_healthy=trueで正常時のオーバーヘッドを削減可能
- circular_buffer_sizeで保持イベント数を制限

## セキュリティ考慮事項

- デバッグダンプにはモデルの重みやデータが含まれる可能性がある
- gRPC経由のデバッグ通信は暗号化を検討すべき
- 本番環境ではデバッグOpの使用を避けること

## 備考

- tfdbg v1: Copy, DebugIdentity, DebugNanCount, DebugNumericSummary
- tfdbg v2: DebugIdentityV2, DebugNumericSummaryV2（循環バッファ対応）
- DebugIdentityV3: io_of_node, is_input, io_index属性でOP入出力の追跡に対応
- AllowsUninitializedInput: 未初期化テンソルも受け入れ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug_ops.cc | `tensorflow/core/ops/debug_ops.cc` | 全8種のデバッグOp定義 |

**主要処理フロー**:
1. **28-35行目**: `Copy` Op - テンソルコピー（debug_ops_spec属性あり）
2. **37-44行目**: `CopyHost` Op - ホスト側テンソルコピー
3. **46-55行目**: `DebugIdentity` Op - デバッグID変換（v1）
4. **57-70行目**: `DebugIdentityV3` Op - 入出力追跡付きデバッグID変換
5. **72-81行目**: `DebugNanCount` Op - NaN数カウント（スカラー出力）
6. **83-96行目**: `DebugNumericSummary` Op - 数値統計（lower/upper_bound付き）
7. **99-111行目**: `DebugIdentityV2` Op - v2デバッグID変換（循環バッファ対応）
8. **113-120行目**: `DebugNumericSummaryV2` Op - v2数値統計

#### Step 2: Pythonデバッグライブラリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dumping_callback.py | `tensorflow/python/debug/lib/dumping_callback.py` | デバッグダンプコールバック |
| 2-2 | check_numerics_callback.py | `tensorflow/python/debug/lib/check_numerics_callback.py` | 数値チェックコールバック |
| 2-3 | debug_events_writer.py | `tensorflow/python/debug/lib/debug_events_writer.py` | デバッグイベントライター |

#### Step 3: デバッグCLIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | analyzer_cli.py | `tensorflow/python/debug/cli/analyzer_cli.py` | CLI分析ツール |
| 3-2 | framework.py | `tensorflow/python/debug/wrappers/framework.py` | セッションラッパーフレームワーク |

### プログラム呼び出し階層図

```
RunOptions.debug_options (ユーザ設定)
    │
    ├─ デバッグOp自動挿入
    │      ├─ Copy / CopyHost
    │      ├─ DebugIdentity / DebugIdentityV2 / DebugIdentityV3
    │      ├─ DebugNanCount
    │      └─ DebugNumericSummary / DebugNumericSummaryV2
    │
    ├─ デバッグイベント出力
    │      ├─ ファイルダンプ (debug_events_writer.py)
    │      └─ gRPC送信 (grpc_debug_server.py)
    │
    └─ CLI/TensorBoard表示
           ├─ analyzer_cli.py
           └─ TensorBoard Debugger Plugin
```

### データフロー図

```
[入力]                     [処理]                          [出力]

任意テンソル          ───▶  DebugIdentity               ───▶  同一テンソル（後続へ）
                            │
                            └──▶ デバッグイベント         ───▶  ファイル / gRPC / CLI

任意テンソル          ───▶  DebugNanCount               ───▶  NaN数 (int64 scalar)

任意テンソル          ───▶  DebugNumericSummary          ───▶  統計サマリー (double)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| debug_ops.cc | `tensorflow/core/ops/debug_ops.cc` | ソース | デバッグOp定義 |
| dumping_callback.py | `tensorflow/python/debug/lib/dumping_callback.py` | ソース | デバッグダンプコールバック |
| check_numerics_callback.py | `tensorflow/python/debug/lib/check_numerics_callback.py` | ソース | 数値チェックコールバック |
| debug_events_writer.py | `tensorflow/python/debug/lib/debug_events_writer.py` | ソース | イベントライター |
| debug_events_reader.py | `tensorflow/python/debug/lib/debug_events_reader.py` | ソース | イベントリーダー |
| analyzer_cli.py | `tensorflow/python/debug/cli/analyzer_cli.py` | ソース | CLI分析ツール |
| framework.py | `tensorflow/python/debug/wrappers/framework.py` | ソース | デバッグセッションラッパー |
| grpc_wrapper.py | `tensorflow/python/debug/wrappers/grpc_wrapper.py` | ソース | gRPCラッパー |
